####################################################################################################

VIDEO_PREFIX = "/video/drnu"

APIURL = "http://www.dr.dk/NU/api/%s"

NAME = "DR NU"
ART			  = 'art-default.png'
ICON		  = 'DR.png'



####################################################################################################

def Start():
	Plugin.AddPrefixHandler(VIDEO_PREFIX, VideoMainMenu, NAME, ICON, ART)
	Plugin.AddViewGroup("InfoList", viewMode="InfoList", mediaType="items")
	Plugin.AddViewGroup("List", viewMode="List", mediaType="items")
	MediaContainer.art = R(ART)
	MediaContainer.title1 = NAME
	DirectoryItem.thumb = R(ICON)
	
	HTTP.CacheTime = 3600
	HTTP.Headers['User-Agent'] = 'Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_6_7; en-us) AppleWebKit/534.16+ (KHTML, like Gecko) Version/5.0.3 Safari/533.19.4'

def VideoMainMenu():
	dir = MediaContainer(viewGroup="List")
	dir.Append(Function(DirectoryItem(ProgramSerierMenu,"Programmer",subtitle="Alle programserier", summary="",thumb=R(ICON),art=R(ART)),id=None))
	return dir

def ProgramSerierMenu(sender,id):
	dir=MediaContainer(title1="DR NU", title2="Programserier")
	JSONObject=JSON.ObjectFromURL(APIURL % "programseries.json")
	for program in JSONObject:
		slug=program["slug"]
		title=program["title"]
		summary="None"
		summary=program["description"]
		thumb=APIURL % "programseries/" + slug + "/images/600x600.jpg"
		dir.Append(Function(DirectoryItem(ProgramMenu,title=title,subtitle=summary,thumb=thumb,summary=summary),id=slug))
	return dir

def ProgramMenu(sender,id):
	dir=MediaContainer(viewGroup="List", title1="DR NU", title2="Programserier")
	JSONObject = JSON.ObjectFromURL(APIURL % "programseries/" + id + "/videos")
	for item in JSONObject:
		key=APIURL % "videos/" + str(item["id"])
		thumb=APIURL % "videos/" + str(item["id"]) + "/images/600x600.jpg"
		title=item["title"] + ": " + item["formattedBroadcastTime"]
		subtitle=item["description"]
		dir.Append(Function(VideoItem(GetVideos, title=title,subtitle=subtitle, thumb=thumb), id=item["videoResourceUrl"]))
	return dir

def GetVideos(sender,id):
	content = JSON.ObjectFromURL(id)
	map = dict()
	for video in content["links"]:
		quality=int(video["qualityId"])
		uri = video["uri"]
		map[quality] = uri
	bestUri = map[sorted(map)[0]]
	tempclip = bestUri.split(":")
	clip = 'http://vodfiles.dr.dk/' + tempclip[2]
	Log(clip)
	return Redirect(clip)
	
	
	