<?php

//PLEX MEDIA LIBRARY CLASS
//alexander

require("config.php");

function return_date($string)
{
	$timestamp = $string;
	$currentTime = new DateTime();
	$currentTime = DateTime::createFromFormat( 'U', $timestamp );
	$formattedString = $currentTime->format( 'Y-m-d H:i:s' );
	
	return $formattedString;
}
function return_runtime($milliseconds) {
    $seconds = floor($milliseconds / 1000);
    $minutes = floor($seconds / 60);
    $hours = floor($minutes / 60);
    $milliseconds = $milliseconds % 1000;
    $seconds = $seconds % 60;
    $minutes = $minutes % 60;

    $format = '%u:%02u:%02u';
    $time = sprintf($format, $hours, $minutes, $seconds);
    return rtrim($time, '0');
}

class PlexMediaLibrary
{
	
	
		public function fetch_movies()
		{
			global $token;
			global $host;
			global $section_movies;
			
			$url = "http://$host/library/sections/$section_movies/all?X-Plex-Token=$token";
			$imgurl = "http://$host/photo/:/transcode?url=";
			$imgurlendhq = "&width=300&height=300&X-Plex-Token=$token";
			$achxml = simplexml_load_file($url);

			//var_dump($achxml);



			foreach ($achxml as $xml)
			{
				$movie_title = $xml["title"] ;//album title
				$tagline = $xml["tagline"];
				$summary = $xml["summary"];
				$rating = $xml["rating"];
				$studio = $xml["studio"];
				$resolution = $xml->Media["videoResolution"];
				$file = $xml->Media->Part["file"];
				$genres = array();
				foreach($xml->Genre as $genre)
				{
					$genres[] = $genre["tag"];
        
        
				}
				$genre_list = implode("/",$genres);
				$year = $xml["year"];
				$release_date = $xml["originallyAvailableAt"];
				$ratingkey = $xml["ratingKey"]; //used for posters 
				$date = $xml["addedAt"];
				$cover  = $imgurl.$xml['thumb'].$imgurlendhq; //posters cover url
				//grab the image and save it ,(for the posters, to speed up image loading)
			//	if(!file_exists("images/movies/$ratingkey.jpg"))
				//{
				//	file_put_contents("images/movies/$ratingkey.jpg", file_get_contents($cover));
			//	}
     
				if($genre == "")
				{
					$genre = "~";
				}
				if($summary == "")
				{
					$summary = "No information available.";
				}
				else
				{
					$summary = $summary;
				}
				if($resolution == "")
				{
					$resolution = "~";
				}
				else
				{
					$resolution = $resolution;
				}
				if($studio == "")
				{
					$studio = "~";
				}
				else
				{
					$studio = $studio;
				}
					if($tagline == "")
				{
					$tagline = "~";
				}
				else
				{
					$tagline = $tagline;
				}
	
	//generate array
	$movies_array[] = array
	(
		"rating_key" => $ratingkey,
		"movie_title" => $movie_title,
		"tagline" => $tagline,
		"summary" => $summary,
		"rating" => $rating,
		"studio" => $studio,
		"resolution" => $resolution,
		"file" => $file,
		"genres" => $genre_list,
		"year" => $year,
		"release_date" => $release_date,
		"date_added"=> $date,
		"poster" => $cover,
	);
		}
		return $movies_array;
		}//end movies function
		
		public function fetch_movie_data($ratingkey)
		{
			
			global $token;
			global $host;
			global $section_movies;
			
			$url = "http://$host/library/metadata/$ratingkey?checkFiles=1&includeExtras=1&includeBandwidths=1&X-Plex-Token=$token";
			$imgurl = "http://$host/photo/:/transcode?url=";
			$imgurlendhq = "&width=300&height=300&X-Plex-Token=$token";
			$achxml = simplexml_load_file($url);
			
			foreach($achxml->Video as $data)
			{
				$title = $data["title"];
				$studio = $data["studio"];
				$content_rating = $data["contentRating"];
				$summary = $data["summary"];
				$rating = $data["rating"];
				$audience_rating = $data["audienceRating"];
				$year = $data["year"];
				$tagline = $data["tagline"];
				$release_date = $data["originallyAvailableAt"];
				$date_added = return_date($data["addedAt"]);
				$resolution = $data->Media["videoResolution"];
				$audio_channel = $data->Media["audioChannels"];
				$format = $data->Media["container"];
				$duration = return_runtime($data->Media["duration"]);
				$file_location = $data->Media->Part["file"];
				$poster  = $imgurl.$data['thumb'].$imgurlendhq; //posters cover url
				$genres = array();
				foreach($data->Genre as $genre)
				{
					$genres[] = array
					(
						"genre_id" => $genre["id"],
						"genre_tag" => $genre["tag"],
					);
        
				}
				$genre = $genres;
				$director = $data->Director["tag"];
				$writers = array();
				
				foreach($data->Writer as $writer)
				{
					$writers[] = $writer["tag"];
					
				}
				
				$writers = implode(",",$writers);
				
				$producers = array();
				
				foreach($data->Producer as $producer)
				{
					$producers[] = $producer["tag"];
				}
				$producers = implode(",",$producers);
				$country = $data->Country["tag"];
				
				
				foreach($data->Role as $role)
				{
					$actor_name = $role["tag"];
					$actor_role = $role["role"];
					$actor_img = $role["thumb"];
					
					$actors[] = array
					(
						"name" => html_entity_decode($actor_name),
						"role" => $actor_role,
						"thumb" => $actor_img,
						
					);
					
				}
				$actors = $actors;
				
				foreach($data->Similar as $similar)
				{
					$similar_id = $similar["id"];
					$similar_title = $similar["tag"];
					
					$similar_titles[] = array
					(
						"rating_key" => $similar_id,
						"similar_title" => $similar_title,
					);
				}
			}
			$movie_array = array
			(
				"poster" => $poster,
				"title" => $title,
				"year" => $year,
				"studio" => $studio,
				"content_rating" => $content_rating,
				"rating" => $rating,
				"summary" => $summary,
				"audience_rating" => $audience_rating,
				"tagline" => $tagline,
				"release_date" => $release_date,
				"date_added" => $date_added,
				"country" => $country,
				"file" => array
				(
					"format" => $format,
					"runtime" => $duration,
					"resolution" => $resolution,
					"audio_channel"=> $audio_channel,
					"file" => $file_location,
				),
				"genres" => $genre,
				"director" => $director,
				"writers" => $writers,
				"producers" => $producers,
				"actors" => $actors,
				"similar_movies" => $similar_titles,
				
			);
				return $movie_array;
				
		}
}
?>