# NEW VERSION BY GYALIS
# Modified version of "plexport" originally created by Zoara.  Modified by Gyalis.  I have no idea where Zoara is
# heading with his/her version, so I don't want to mess up what he/she is doing.  I took a few programming shortcuts, so
# this version can just be my "hacked" version.  Or if Zoara wants to add what I've done to the existing project, great.

# I've added HTML.  This now creates 3 html files on the desktop by default.  One with movies only, one with TV shows only,
# and another with both movies and TV shows.  These files link to each other, so you can bounce between them in your browser.
# The entries link to a YouTube search for the trailers.
# I've managed to get the TV show information out in one query, but there is an issue with some shows having multiple IDs
# ...which means they come back in multiple rows with the same season number.  I can probably fix it in the query, but
# I just noticed it, so I'm leaving it till I decide to touch this again.  All it does is cause the seasons to be SOMETIMES
# be displayed like this "Seasons: 1 (11 eps) 1 (1 eps) 2 (3 eps) 2 (9 eps)" instead of this "Seasons: 1 (12 eps) 2 (12 eps)".
# It happened on 3 of my 13 TV shows.

# I may have re-introduced a sorting bug, but I don't think so.  I'm unnable to test since I don't have any shows with more
# than 9 seasons

# Original documentation by Zoara:
    # title:	plexport
    # function: exports contents of plex database to a human-friendly text file
    # author: 	zoara -- twitter.com/zoara

    # version history
    # 0.1	08-SEP-09 	ultra quick-n-hacky proof of concept
    # 0.2	12-SEP-09 	displays series/episode information
    # 0.3	12-SEP-09	failed attempts at fairly pointless british/american english localisations
    # 0.4	13-SEP-09	renders non-ASCII properly - bloody bom
    # 1.0	13-SEP-09	tidied for release: presents itself as "plexport" rather than "plexport.py"
    # 1.01	04-OCT-09	Correctly orders seasons above ten; 1, 4, 10, 23 instead of 1, 10, 23, 4
    # 1.02	04-OCT-09	Fixes problem where shows with apostrophes didn't display episode counts

    # known issues
    # - destination file is hard-coded and overwrites any existing plexport.txt on the desktop
    # - british english localisation doesn't work; issues with plex?
    # - inefficiency of multiple sql calls (could be slow with large libraries)
    # - html or rtf formatting might be a nice feature
    # - windows / xbmc compatibility (save location needs abstracting)

import locale
import xbmc, xbmcgui 
from urllib import quote
import re
import sys
import os
import codecs
import string


# sort of my hackish way of doing the TV shows
gl_LastShowPrinted = ''

# used to sort list as integers
def integerComparison(a, b):
    return cmp(int(a), int(b)) 

def WriteHTMLHeader(htmlFile, Title):
    htmlFile.write('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"')
    htmlFile.write('"http://www.w3.org/TR/html4/loose.dtd">')
    htmlFile.write('<html><head>')
    htmlFile.write('<META name="description" content="">')
    htmlFile.write('<meta http-equiv="Content-Style-Type" content="text/css">')
    htmlFile.write('<meta name="google-site-verification" content="N5Loe6cpy-oQG3NEdO-QcIqnZQKp1V7rklZM8PToXzQ" />')
    htmlFile.write('<link href="http://www.movie-list.com/scripts/style.css" rel="stylesheet" type="text/css">')
    htmlFile.write('<link href="http://www.movie-list.com/scripts/layout.css" rel="stylesheet" type="text/css">')
    htmlFile.write('<link href="http://www.movie-list.com/scripts/ml.css" rel="stylesheet" type="text/css">')
    htmlFile.write('<script language="JavaScript" type="text/JavaScript" src="http://www.movie-list.com/scripts/scripts.js"></script>')
    htmlFile.write('<table class="index" cellspacing="0" border="0">')
    htmlFile.write('<tr><td class="indexheader" colspan="2">')
    htmlFile.write(Title)
    htmlFile.write('</tr>')
    htmlFile.write('<tr>')
    htmlFile.write('<td class="indexheader" colspan="2">[<a href="')
    htmlFile.write(baseFileNameLib)
    htmlFile.write('">Full Library</a>]')
    htmlFile.write('[<a href="')
    htmlFile.write(baseFileNameMovies)
    htmlFile.write('">Movies Only</a>]')
    htmlFile.write('[<a href="')
    htmlFile.write(baseFileNameShows)
    htmlFile.write('">TV Shows Only</a>]')
    htmlFile.write('</td></tr>')
    htmlFile.write('<tr><td class="indexitem"></TD><TD class="indexitem2" width="100%"><BR>')
def AddMovieToHTML(htmlFile, theVid):
    thumbs = theVid[6]
    thumb = thumbs[15:thumbs.find("</thumb>")]
    htmlFile.write ('<table width="100%"><tr><td width="136" valign="top"><A HREF="')
    htmlFile.write (GetYouTubeURL(theVid[0]))
    htmlFile.write ('">')
    htmlFile.write ('<img class="index_content" align="left" src="')
    htmlFile.write (thumb)
    htmlFile.write ('"></A></td><td align="left" valign="top">')
    htmlFile.write ('<A HREF="')
    htmlFile.write (GetYouTubeURL(theVid[0]))
    htmlFile.write ('"><span class="indextitle">')
    htmlFile.write (theVid[0])
    htmlFile.write ('</span></A><BR><span class="smalltext2">')
    htmlFile.write (theVid[1])
    htmlFile.write ('</span><BR><BR><SPAN CLASS="crew">Release Year:</span> <span class="smalltext2">')
    htmlFile.write (theVid[2])
    htmlFile.write ('</span><BR><SPAN CLASS="crew">Director:</span> <span class="smalltext2">')
    htmlFile.write (theVid[3])
    htmlFile.write ('</span><BR><SPAN CLASS="crew">Writer:</span> <span class="smalltext2">')
    htmlFile.write (theVid[4])
    htmlFile.write ('</span><BR><SPAN CLASS="crew">Genre:</span> <span class="smalltext2">')
    htmlFile.write (theVid[5])
    htmlFile.write ('</span><BR><SPAN CLASS="crew">File:</span> <span class="smalltext2">')
    htmlFile.write (theVid[7])
    htmlFile.write ('</span><BR><SPAN CLASS="crew">IMDB Rating:</span> <span class="smalltext2">')
    htmlFile.write (theVid[8])
    htmlFile.write ('</span><BR><SPAN CLASS="crew">Runtime:</span>')
    htmlFile.write (theVid[9])
    htmlFile.write ('</td></tr></table>') # or CloseHTMLTable(htmlFile)
def AddShowToHTMLDoesntCloseLastTable(htmlFile, theVid, LastShowPrinted): # Needs to return the showID of the show it just printed
    showID = theVid[0]+theVid[5] #Using title and air date as unique ID since the showid from the database is not reliable
                                    # (two shows can have the same title...especially remakes)

    if showID == LastShowPrinted:
        htmlFile.write ('<span class="smalltext2">')
        htmlFile.write (theVid[6])
        htmlFile.write ('</span><SPAN CLASS="crew"> (')
        htmlFile.write (theVid[7])
        htmlFile.write (' eps) </span>')
    else:
        if LastShowPrinted != '':
            # Closing off previous table if this isn't the first one
            CloseHTMLTable(htmlFile)

        # Starting new table
        thumbs = theVid[2]
        thumb = thumbs[15:thumbs.find("</thumb>")]
        htmlFile.write ('<table width="100%"><tr><td width="136" valign="top"><A HREF="')
        htmlFile.write (GetYouTubeURL(theVid[0]))
        htmlFile.write ('">')
        htmlFile.write ('<img class="index_content" align="left" src="')
        htmlFile.write (thumb)
        htmlFile.write ('"></A></td><td align="left" valign="top">')
        htmlFile.write ('<A HREF="')
        htmlFile.write (GetYouTubeURL(theVid[0]))
        htmlFile.write ('"><span class="indextitle">')
        htmlFile.write (theVid[0])
        htmlFile.write ('</span></A><BR><span class="smalltext2">')
        htmlFile.write (theVid[1])
        htmlFile.write ('</span><BR><BR><SPAN CLASS="crew">Date First Aired:</span> <span class="smalltext2">')
        htmlFile.write (theVid[5])
        htmlFile.write ('</span><BR><SPAN CLASS="crew">Genre:</span> <span class="smalltext2">')
        htmlFile.write (theVid[3])
        htmlFile.write ('</span><BR><SPAN CLASS="crew">IMDB Rating:</span> <span class="smalltext2">')
        htmlFile.write (theVid[4])
        htmlFile.write ('</span><BR>')
        htmlFile.write ('<SPAN CLASS="crew">Seasons: </span> ')
        htmlFile.write ('<span class="smalltext2">')
        htmlFile.write (theVid[6])
        htmlFile.write ('</span><SPAN CLASS="crew"> (')
        htmlFile.write (theVid[7])
        htmlFile.write (' eps) </span>')
    return showID
def CloseHTMLTable(htmlFile): # I really don't like having this function
    htmlFile.write ('</td></tr></table>')

def GetMovies():
    # Query the database for movie titles and parse into a list
    response = xbmc.executehttpapi("QueryVideoDatabase(%s)" % quote("select c00 || '<|>'|| c02 || '<|>'||"+
    "c07 || '<|>'|| c15 || '<|>'|| c06 || '<|>'|| c14 || '<|>' || c08 || '<|>' || strFilename || '<|>' || c05 || '<|>' || c11 "+
    "from movie m join files f "+
    "on m.idFile = f.idFile"))
    #debugFile.write(response)
    movies = re.findall("<field>(.*?)</field>", response, re.DOTALL)
    return movies
def GetTVShows():
    # Query the database for tv shows and parse into a list
    # Title0, synopsis1, thumbs2, genre3, rating4, date aired5, season_num6, episode_count7, showid8
    response = xbmc.executehttpapi("QueryVideoDatabase(%s)" % quote("select tvshow.c00   || '<|>'|| tvshow.c01  || "+
    "'<|>'||  tvshow.c06 || '<|>'||  tvshow.c08  || '<|>'||  tvshow.c04 || '<|>'||  tvshow.c05 || '<|>'|| "+
    "ep.c12 || '<|>'||  cast(ep.epCount as char(4)) || '<|>' || cast(tvShow.idShow as varchar(20)) "+
    "from tvshow "+
    ",(select count(*) as epCount, tsle.idShow, c12 from episode e "+
    "join tvshowlinkepisode tsle "+
    "on e.idEpisode = tsle.idEpisode "+
    "group by 2,3) ep "+
    "where ep.idShow = tvShow.idShow  "+
    "order by tvshow.c00, ep.c12"))
    shows = re.findall("<field>(.*?)</field>", response, re.DOTALL)
    return shows
def GetYouTubeURL(movieTitle):
    toReturn = "http://www.youtube.com/results?search_query="
    toReturn += movieTitle.replace(' ','+')
    toReturn += "+trailer&aq=f"
    return toReturn

# save location for file
baseFileNameLib = 'plexport.html'
baseFileNameMovies = 'plexportMovies.html'
baseFileNameShows = 'plexportShows.html'
outFile = open(os.path.expanduser('~') + '/Desktop/'+baseFileNameLib, 'w')
outFile.write(codecs.BOM_UTF8)
outFileMovies = open(os.path.expanduser('~') + '/Desktop/'+baseFileNameMovies, 'w')
outFileMovies.write(codecs.BOM_UTF8)
outFileShows = open(os.path.expanduser('~') + '/Desktop/'+baseFileNameShows, 'w')
outFileShows.write(codecs.BOM_UTF8)

# default american localisation
moviesString = "Movies"
showsString = "Shows"
seasonString = "Season"

# write movies to the file
WriteHTMLHeader(outFile, 'Library')
WriteHTMLHeader(outFileMovies, 'Movies')
WriteHTMLHeader(outFileShows, 'TV Shows')

movies = GetMovies()
for movie in sorted(movies):
    infolist = string.split(movie,'<|>')
    AddMovieToHTML(outFile, infolist)
    AddMovieToHTML(outFileMovies, infolist)

shows = GetTVShows()
previousIDMain = ''
previousIDShows = ''
for show in shows:
    infolist = string.split(show,'<|>')
    previousIDMain = AddShowToHTMLDoesntCloseLastTable(outFile, infolist, previousIDMain)
    previousIDShows = AddShowToHTMLDoesntCloseLastTable(outFileShows, infolist, previousIDShows)    
CloseHTMLTable(outFile)#Need to do this because of the way I write the shows to the file :-/
CloseHTMLTable(outFileShows)#Need to do this because of the way I write the shows to the file :-/

outFile.write('</td></tr></body></html>')
outFileMovies.write('</td></tr></body></html>')
outFileShows.write('</td></tr></body></html>')

outFile.close()
outFileMovies.close()
outFileShows.close()


