# This agent is based on the Wrestling TVRage metadata agent by
#  akkifokkusu https://forums.plex.tv/index.php/topic/73947-alpha-wrestling-metadata-agent/
#
# However, this agent is more of a general TVRage agent.  It will use
# TVRage to get series and episode summary data.  Since TVRage doesn't
# supply banners, we use TheMovieDB to lookup the TVDB id and then
# TVDB to get banners
#
# Note: I probably could have used TheMovieDB to directly get the banners, see:
#   http://docs.themoviedb.apiary.io/reference/tv-seasons/tvidseasonseasonnumberimages/get
# and not used TVDB at all, but 

#   1) TVDB banners were already working in Wrestling if you provided the correct seriesid
#   2) So far, TheMovidDB doesn't seem to have as complete a set of banners as TVDB

# TVRage urls
TVRAGE_SEARCH_URL = 'http://services.tvrage.com/feeds/search.php?show=%s'
TVRAGE_SHOW_INFO_URL = 'http://services.tvrage.com/myfeeds/showinfo.php?key=P8q4BaUCuRJPYWys3RBV&sid=%s'
TVRAGE_EP_INFO_URL = 'http://services.tvrage.com/myfeeds/episode_list.php?key=P8q4BaUCuRJPYWys3RBV&sid=%s'

# TVDB urls
TVDB_BANNER_LIST_URL = 'http://thetvdb.com/api/D4DDDAEFAD083E6F/series/%s/banners.xml'
TVDB_BANNER_BASE_URL = 'http://thetvdb.com/banners/'

# TheMovieDB urls
BASE_URL = 'https://api.tmdb.org/3'
API_KEY = 'a3dc111e66105f6387e99393813ae4d5'
TVRAGE2TMDB_ID_URL = '%s/tv/find/%%s?api_key=%s&external_source=tvrage_id' % (BASE_URL, API_KEY)
TMDB2TVDB_ID_URL = '%s/tv/%%s/external_ids?api_key=%s' % (BASE_URL, API_KEY)

def GetJSON(url, cache_time=CACHE_1MONTH):
  tmdb_dict = None
  try:
	tmdb_dict = JSON.ObjectFromURL(url, sleep=2.0, headers={'Accept': 'application/json'}, cacheTime=cache_time)
  except:
	Log('Error fetching JSON from The Movie Database.')
  return tmdb_dict


def Start():

	HTTP.CacheTime = CACHE_1DAY


class TVRagePlusAgent(Agent.TV_Shows):

	name = 'TVRagePlus'
	languages = [Locale.Language.English]
	primary_provider = True
	accepts_from = ['com.plexapp.agents.localmedia']

	def search(self, results, media, lang):
		if Prefs["clearcache"]:
			HTTP.ClearCache()
		Log("Working!:")
		#Log("Name?: " + media.name)
		Log("Show?: " + media.show)
		searchurl = TVRAGE_SEARCH_URL % String.Quote(media.show,True)
		Log("Searching using URL: " + searchurl)
		xml = XML.ElementFromURL(searchurl)
		curscore = 49
		if media.show.lower() == xml.xpath("//show/name")[0].text.lower():
			curscore = 100
		for match in xml.xpath("//show"):
			nextResult = MetadataSearchResult(id=str(match.xpath("./showid")[0].text),name=str(match.xpath("./name")[0].text),year=match.xpath("./started")[0].text,score=curscore,lang=lang)
			results.Append(nextResult)
			Log(repr(nextResult))
			#Log("id = " + match.xpath("./showid")[0].text)
			#Log("name = " + match.xpath("./name")[0].text)
			#Log("year = " + match.xpath("./started")[0].text)
			#Log("score = " + str(curscore))
			curscore = curscore - 1

	def update(self, metadata, media, lang):
		if Prefs["clearcache"]:
			HTTP.ClearCache()
		Log("Working!:")
		Log(metadata.id)
		xml = XML.ElementFromURL(TVRAGE_SHOW_INFO_URL % metadata.id)
		metadata.title = xml.xpath("/Showinfo/showname")[0].text
		metadata.studio = xml.xpath("/Showinfo/network")[0].text
		metadata.duration = int(xml.xpath("/Showinfo/runtime")[0].text) * 60 * 1000
		metadata.originally_available_at = Datetime.ParseDate(xml.xpath("/Showinfo/started")[0].text).date()
		metadata.genres = [genre.text for genre in xml.xpath("/Showinfo/genres/genre")]
		if xml.xpath("/Showinfo/summary"):
			metadata.summary = xml.xpath("/Showinfo/summary")[0].text
		#Log([genre.text for genre in xml.xpath("/Show/genres/genre")])
		metadata.countries = [xml.xpath("/Showinfo/origin_country")[0].text]
		metadata.tags = [xml.xpath("/Showinfo/classification")[0].text]


		# The metadata.id for this item is a TVRage id.  We The Movie DB to lookup the corresponding TVDB id
		# so we can get banner data from TVDB
		Log("Looking up TVDB series id from TheMovieDB")
		seriesid = ""
 		tmdb_dict = GetJSON(url=TVRAGE2TMDB_ID_URL % (metadata.id))
 		if isinstance(tmdb_dict, dict) and 'tv_results' in tmdb_dict and len(tmdb_dict['tv_results']) > 0:
 			tmdb_id = tmdb_dict['tv_results'][0]['id']
 			tmdb_dict = GetJSON(url=TMDB2TVDB_ID_URL % (tmdb_id))
 			if isinstance(tmdb_dict, dict):
				seriesid=str(tmdb_dict['tvdb_id'])
				Log("Got seriesid" + seriesid)

		# We found the TVDB seriesid, so use it to get banner information from TVDB
		if len(seriesid) > 0:
			Log("Banner url: " + TVDB_BANNER_LIST_URL % seriesid)
			xml2 = XML.ElementFromURL(TVDB_BANNER_LIST_URL % seriesid)
			for banner in xml2.xpath("/Banners/Banner"):
				Log("Working on banner id: " + banner.xpath("./id")[0].text)
				Log("Banner rating: " + str(banner.xpath("./Rating")[0].text))
				banner_sort = None
				if banner.xpath("./Rating")[0].text is not None:
					banner_sort = int(10 - float(banner.xpath("./Rating")[0].text))
				banner_url = TVDB_BANNER_BASE_URL + banner.xpath("./BannerPath")[0].text
				banner_type = banner.xpath("./BannerType")[0].text
				if banner_type == "fanart":
					if banner_url not in metadata.art:
						try:
							banner_thumb = TVDB_BANNER_BASE_URL + banner.xpath("./ThumbnailPath")[0].text
							metadata.art[banner_url] = Proxy.Preview(HTTP.Request(banner_thumb), banner_sort)
						except:
							metadata.art[banner_url] = Proxy.Media(HTTP.Request(banner_url), banner_sort)
				elif banner_type == "poster":
					if banner_url not in metadata.posters:
						try:
							banner_thumb = TVDB_BANNER_BASE_URL + banner.xpath("./ThumbnailPath")[0].text
							metadata.posters[banner_url] = Proxy.Preview(HTTP.Request(banner_thumb), banner_sort)
						except:
							metadata.posters[banner_url] = Proxy.Media(HTTP.Request(banner_url), banner_sort)
				elif banner_type == "series":
					if banner_url not in metadata.banners:
						metadata.banners[banner_url] = Proxy.Media(HTTP.Request(banner_url), banner_sort)
				elif banner_type == "season":
					banner_season = banner.xpath("./Season")[0].text
					if banner_season in media.seasons:
						if banner.xpath("./BannerType2")[0].text == "season":
							if banner_url not in metadata.seasons[banner_season].posters:
								metadata.seasons[banner_season].posters[banner_url] = Proxy.Media(HTTP.Request(banner_url), banner_sort)
						elif banner.xpath("./BannerType2")[0].text == "seasonwide":
							if banner_url not in metadata.seasons[banner_season].banners:
								metadata.seasons[banner_season].banners[banner_url] = Proxy.Media(HTTP.Request(banner_url), banner_sort)

		# Use TVRage to get episode summaries, etc
		Log("Working on seasons! (TVRage) ")
		xml3 = XML.ElementFromURL(TVRAGE_EP_INFO_URL % metadata.id)
		for season in xml3.xpath("/Show/Episodelist/Season"):
			season_no = season.get("no")
			if season_no in media.seasons:
				Log("Season matched: " + season_no)
				for episode in season.xpath("./episode"):
					episode_no = str(int(episode.xpath("./seasonnum")[0].text))
					if episode_no in media.seasons[season_no].episodes:
						Log("Episode matched: " + episode_no)
						ep_object = metadata.seasons[season_no].episodes[episode_no]
						ep_object.title = episode.xpath("./title")[0].text
						if episode.xpath("./summary"):
							ep_object.summary = episode.xpath("./summary")[0].text
						#ep_object.rating = ""
						Log("Date: " + str(Datetime.ParseDate(episode.xpath("./airdate")[0].text).date()))
						ep_object.originally_available_at = Datetime.ParseDate(episode.xpath("./airdate")[0].text).date()
						Log("Abs: " + str(int(episode.xpath("./epnum")[0].text)))
						ep_object.absolute_index = int(episode.xpath("./epnum")[0].text)
						if len(episode.xpath("./screencap")) > 0:
							thumb_url = episode.xpath("./screencap")[0].text
							if thumb_url not in ep_object.thumbs:
								ep_object.thumbs[thumb_url] = Proxy.Media(HTTP.Request(thumb_url))
		Log("Done with seasons!")
