
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.DefaultCaret;

public class UI extends JFrame {

    public UI() {
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Windows".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(UI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }

        // Setting up the main frame
        final JFrame frame = this;
        final Object ui = this;
        setTitle("Movie Renamer");
        setSize(750, 600);
        setLocationRelativeTo(null);
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        setLayout(null);
        setResizable(false);

        /* setting up components for main frame */
        // source field
        source = new JTextField();
        source.setToolTipText("Select the location of the folder to monitor for movies");
        source.setSize(585, 40);
        source.setLocation(25, 50);
        source.setEditable(false);
        source.setBackground(Color.white);
        source.setFont(font);
        source.setFocusable(false);
        this.add(source);

        // destination field
        destination = new JTextField();
        destination.setToolTipText("Select the location of the folder to move renamed movies to");
        destination.setSize(585, 40);
        destination.setLocation(25, 125);
        destination.setEditable(false);
        destination.setBackground(Color.white);
        destination.setFont(font);
        destination.setFocusable(false);
        this.add(destination);

        // log text area
        log = new JTextArea();
       // log.setSize(694, 245);
        // log.setLocation(25, 300);
        log.setEditable(false);
        // log.setBackground(Color.white);
        log.setFont(font);
        DefaultCaret caret = (DefaultCaret) log.getCaret();
        caret.setUpdatePolicy(DefaultCaret.ALWAYS_UPDATE);
       // border = source.getBorder();
        // log.setBorder(border);
        // log.setLineWrap(true);

        scrollLog = new JScrollPane(log);
        scrollLog.setSize(694, 245);
        scrollLog.setLocation(25, 300);
        scrollLog.setBackground(Color.white);
        border = source.getBorder();
        scrollLog.setBorder(border);
        this.add(scrollLog);

        // source button
        selectSource = new JButton("Browse");
        selectSource.setSize(100, 42);
        selectSource.setLocation(620, 49);
        selectSource.setFont(font);
        selectSource.setFocusable(false);
        this.add(selectSource);

        // destination button
        selectDestination = new JButton("Browse");
        selectDestination.setSize(100, 42);
        selectDestination.setLocation(620, 124);
        selectDestination.setFont(font);
        selectDestination.setFocusable(false);
        this.add(selectDestination);

        // source label
        sourceLabel = new JLabel("Source:");
        sourceLabel.setSize(100, 25);
        sourceLabel.setLocation(25, 25);
        sourceLabel.setFont(font);
        this.add(sourceLabel);

        // destination label
        destinationLabel = new JLabel("Destination:");
        destinationLabel.setSize(100, 25);
        destinationLabel.setLocation(25, 100);
        destinationLabel.setFont(font);
        this.add(destinationLabel);

        // log label
        logLabel = new JLabel("Log:");
        logLabel.setSize(50, 25);
        logLabel.setLocation(25, 275);
        logLabel.setFont(font);
        this.add(logLabel);

        // status label
        status = new JLabel("Running");
        status.setSize(90, 25);
        status.setLocation(25, 545);
        status.setFont(font);
        status.setVisible(false);
        this.add(status);

        // status icon
        statusIcon = new JLabel();
        statusIcon.setSize(16, 16);
        statusIcon.setLocation(5, 550);
        statusIcon.setVisible(false);
        add(statusIcon);

        // start button
        start = new JButton("Start Monitoring");
        start.setSize(342, 50);
        start.setLocation(24, 200);
        start.setFont(font);
        start.setFocusable(false);
        this.add(start);

        // stop button
        stop = new JButton("Stop Monitoring");
        stop.setSize(342, 50);
        stop.setLocation(378, 200);
        stop.setFont(font);
        stop.setFocusable(false);
        stop.setEnabled(false);
        this.add(stop);
        setVisible(true);

        // loading directories from file if there are any
        LoadDirectories();

        class UIButtonsListener implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == selectSource) {
                    folderChooser.setCurrentDirectory(new java.io.File("."));
                    folderChooser.setDialogTitle("Select a folder to scan for movies...");
                    folderChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
                    folderChooser.setAcceptAllFileFilterUsed(false);
                    if (folderChooser.showOpenDialog(frame) == JFileChooser.APPROVE_OPTION) {
                        File file = folderChooser.getSelectedFile();
                        source.setText(file.getAbsolutePath());
                        SaveDirectoriesToFile();
                    }
                } else if (e.getSource() == selectDestination) {
                    folderChooser.setCurrentDirectory(new java.io.File("."));
                    folderChooser.setDialogTitle("Select a folder to scan for movies...");
                    folderChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
                    folderChooser.setAcceptAllFileFilterUsed(false);
                    if (folderChooser.showOpenDialog(frame) == JFileChooser.APPROVE_OPTION) {
                        File file = folderChooser.getSelectedFile();
                        destination.setText(file.getAbsolutePath());
                        SaveDirectoriesToFile();
                    }
                } else if (e.getSource() == start) {

                    stop.setEnabled(true);
                    start.setEnabled(false);
                    selectDestination.setEnabled(false);
                    selectSource.setEnabled(false);

                    status.setText("Running");
                    statusIcon.setIcon(new ImageIcon("./resources/on.png"));
                    status.setVisible(true);
                    statusIcon.setVisible(true);

                    findMoviesObject = new FindMovies((UI) ui);
                    findMoviesThread = new Thread(findMoviesObject);
                    findMoviesThread.start();

                } else if (e.getSource() == stop) {
                    if (!findMoviesObject.isScanning()) {
                        stop.setEnabled(false);
                        start.setEnabled(true);
                        selectDestination.setEnabled(true);
                        selectSource.setEnabled(true);

                        statusIcon.setIcon(new ImageIcon("./resources/off.png"));
                        status.setText("Not Running");
                        status.setVisible(true);
                        statusIcon.setVisible(true);

                        findMoviesThread.stop();
                    } else {
                        log.setText(log.getText() + "\nthe program is scanning for movies."
                                + " Please wait untill the process is finished before stopping it.");
                    }

                }
            }
        } // closing for UIButtonsListener class

        ActionListener listener = new UIButtonsListener();
        selectSource.addActionListener(listener);
        selectDestination.addActionListener(listener);
        start.addActionListener(listener);
        stop.addActionListener(listener);
    } // closing bracket for UI class

    public void SaveDirectoriesToFile() {
        try (FileWriter fwriter = new FileWriter("./configurations.in", false); PrintWriter fout = new PrintWriter(fwriter);) {
            fout.print(source.getText() + "\n" + destination.getText());
        } catch (IOException ex) {
            System.out.println("problem writing to configurations.in file");
        }
    }

    public void LoadDirectories() {
        File configurations = new File("./configurations.in");
        try {
            Scanner c = new Scanner(configurations);
            source.setText(c.nextLine());
            destination.setText(c.nextLine());
            c.close();
        } catch (FileNotFoundException ex) {
            System.out.println("file not found");
        }
    }

    public String getSource() {
        return source.getText();
    }

    public String getDestination() {
        return destination.getText();
    }

    public void setLog(String str) {
        log.setText(str);
    }

    public String getLog() {
        return log.getText();
    }

    public void writeToLog(String str) {
        if (log.getText().equals("")) {
            log.setText(str);
        } else {
            log.setText(log.getText() + "\n" + str);
        }
    }

    public boolean sourceIsValid() {
        File file = new File(source.getText());
        return file.exists();
    }

    public boolean destinationIsValid() {
        File file = new File(destination.getText());
        return file.exists();
    }

    private JTextField source;
    private JTextField destination;
    private JTextArea log;
    private JButton selectSource;
    private JButton selectDestination;
    private JButton start;
    private JButton stop;
    private JLabel sourceLabel;
    private JLabel destinationLabel;
    private JLabel logLabel;
    private JLabel status;
    private JLabel statusIcon;
    private Border border;
    private final JFileChooser folderChooser = new JFileChooser();
    private Font font = new Font("Lucida Grande", Font.PLAIN, 16);
    private Thread findMoviesThread;
    private FindMovies findMoviesObject;
    private JScrollPane scrollLog;

    void stopMonitoringService() {
        stop.setEnabled(false);
        start.setEnabled(true);
        selectDestination.setEnabled(true);
        selectSource.setEnabled(true);

        statusIcon.setIcon(new ImageIcon("./resources/off.png"));
        status.setText("Not Running");
        status.setVisible(true);
        statusIcon.setVisible(true);

        findMoviesThread.stop();
    }

}
