
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.TmdbSearch;
import info.movito.themoviedbapi.model.MovieDb;
import info.movito.themoviedbapi.model.core.MovieResultsPage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
///////////////////////////////////////////////////////////// if it is a movie, but can't renamed then make it as ##unrenamable##

public class RenameMovie {

    public ArrayList<String> moviesList = new ArrayList<String>();
    public boolean trim = false;
    public int index = -1;
    UI ui;
    String ext;
    String movieYear;

    public RenameMovie(File file, FindMovies findMovies, UI uiClass) {
        ui = uiClass;
        TmdbSearch movies = new TmdbApi("80e7603740a88614c58d4afdc40826da").getSearch();
        MovieResultsPage movie = null;
        List<MovieDb> results = null;
        String movieName = setExtension(file.getName());
        ui.writeToLog("renaming " + movieName);
        movieName = movieName.replace(".", " ");
        movieName = movieName.replace(":", " ");
        movieName = movieName.replace(";", " ");
        movieName = movieName.replace("-", " ");
        movieName = movieName.replace("[", " ");
        movieName = movieName.replace("]", " ");
        movieName = movieName.replace("(", " ");
        movieName = movieName.replace(")", " ");
        movieName = movieName.replace("{", " ");
        movieName = movieName.replace("}", " ");
        movieName = movieName.replaceAll("\\s+", " ");
        movieName = movieName.trim();
        int year = getYear(movieName);
        movieName = TrimMovieName(movieName);
        movieName = movieName.trim();
        String[] words = SplitNameIntoWords(movieName);
        ShowPossibleCrops(words, movies, movie, results, year);
        moveRenamedMovie(file);

    }

    public void ShowPossibleCrops(String[] str, TmdbSearch movies, MovieResultsPage movie, List<MovieDb> results, int year) {
        if (str.length == 0 || str[0].equals("")) {
           // System.out.println("Movie name is empty");
        } else if (str.length == 2) {
            movie = movies.searchMovie(str[0] + " " + str[1], year, "en", false, 0);
            results = movie.getResults();
            if (!results.isEmpty()) {
                movieYear = results.get(0).getReleaseDate();
                moviesList.add(results.get(0).getTitle());
            }
        } else {
            String name = "";
            for (int i = 0; i < str.length; i++) {
                name = (name + " " + str[i]);
                name = name.trim();
                movie = movies.searchMovie(name, year, "en", false, 1);
                results = movie.getResults();
                if (!results.isEmpty()) {
                    movieYear = results.get(0).getReleaseDate();
                    moviesList.add(results.get(0).getTitle());
                }
            }
        }
    }

    public String getMovieName() {
        Map<String, Integer> stringsCount = new HashMap<>();
        for (String s : moviesList) {
            Integer c = stringsCount.get(s);
            if (c == null) {
                c = new Integer(0);
            }
            c++;
            stringsCount.put(s, c);
        }

        Map.Entry<String, Integer> mostRepeated = null;
        for (Map.Entry<String, Integer> e : stringsCount.entrySet()) {
            if (mostRepeated == null || mostRepeated.getValue() < e.getValue()) {
                mostRepeated = e;
            }
        }

        if (mostRepeated != null) {
            return mostRepeated.getKey();
        }
        return null;
    }

    public int getYear(String movieName) {
        for (int i = 1950; i < 2030; i++) {
            if (movieName.contains(i + "")) {
                index = movieName.indexOf(i + "");
                trim = true;
                return i;
            }
        }

        return 0;

    }

    public String TrimMovieName(String str) {
        if (index == 0 && trim == true) {
            getYear(str.substring(4));
            int temp = index + 4;
            trim = false;
            index = -1;
            return str.substring(0, temp);
        } else if (trim == true) {
            int temp = index;
            trim = false;
            index = -1;
            return str.substring(0, temp);
        } else {
            return str;
        }

    }

    public void ShowPossibleCropOne(String str, TmdbSearch movies, MovieResultsPage movie, List<MovieDb> results, int year) {
        movie = movies.searchMovie(str, year, "en", false, 1);
        results = movie.getResults();
        if (!results.isEmpty()) {
            for (int i = 0; i < results.size(); i++) {
                moviesList.add(results.get(i).getTitle());
            }
        }
    }

    public String[] SplitNameIntoWords(String movieName) {
        return movieName.split("\\s+");
    }

    public void moveRenamedMovie(File f) {
        if (getMovieName() == null) {
            f.renameTo(new File(f.getParent() + "\\*unrenamable## " + f.getName()));
            Path movefrom = FileSystems.getDefault().getPath(f.getAbsolutePath());
            Path target = FileSystems.getDefault().getPath(f.getParent() + "\\##unrenamable## " + f.getName());
            try {
                Files.move(movefrom, target, StandardCopyOption.REPLACE_EXISTING);
                ui.writeToLog("movie is unrenamable");
                ui.writeToLog("mlease make sure the movie name and the year are valid");
            } catch (IOException ex) {
                System.out.println("moving faild");
            }
        } else {
            Path movefrom = FileSystems.getDefault().getPath(f.getAbsolutePath());
            Path target;
            File e;
            if (getMovieYear() == null) {
                e = new File(ui.getDestination() + "\\" + removeIllegalName(getMovieName()));
                target = FileSystems.getDefault().getPath(ui.getDestination() + "\\" + removeIllegalName(getMovieName()) + "\\" + removeIllegalName(getMovieName()) + ext);
            } else {
                e = new File(ui.getDestination() + "\\" + removeIllegalName(getMovieName()) + " (" + getMovieYear() + ")");
                target = FileSystems.getDefault().getPath(ui.getDestination() + "\\" + removeIllegalName(getMovieName()) + " (" + getMovieYear() + ")" + "\\" + removeIllegalName(getMovieName()) + ext);
            }
            e.mkdir();
            try {
                Files.move(movefrom, target, StandardCopyOption.REPLACE_EXISTING);
                ui.writeToLog("renaming was successful");
            } catch (IOException ex) {
                ui.writeToLog("renaming was unsuccessful");
                System.out.println("moving faild");
            }
        }
    }

    public String getExtension(String str) {
        if (str.contains(".mkv")) {
            return str.substring(str.indexOf(".mkv"));
        } else if (str.contains(".avi")) {
            return str.substring(str.indexOf(".avi"));
        } else if (str.contains(".mp4")) {
            return str.substring(str.indexOf(".mp4"));
        } else if (str.contains(".mov")) {
            return str.substring(str.indexOf(".mov"));
        } else if (str.contains(".mpg")) {
            return str.substring(str.indexOf(".mpg"));
        } else if (str.contains(".mpv")) {
            return str.substring(str.indexOf(".mpv"));
        } else if (str.contains(".m4v")) {
            return str.substring(str.indexOf(".m4v"));
        } else {
            return str.substring(str.indexOf(".mkv"));
        }
    }

    /// continue here
    public String setExtension(String str) {
        if (str.contains(".mkv")) {
            ext = str.substring(str.indexOf(".mkv"));
            return str.substring(0, str.indexOf(".mkv"));
        } else if (str.contains(".avi")) {
            ext = str.substring(str.indexOf(".avi"));
            return str.substring(0, str.indexOf(".mkv"));
        } else if (str.contains(".mp4")) {
            ext = str.substring(str.indexOf(".mp4"));
            return str.substring(0, str.indexOf(".mkv"));
        } else if (str.contains(".mov")) {
            ext = str.substring(str.indexOf(".mov"));
            return str.substring(0, str.indexOf(".mkv"));
        } else if (str.contains(".mpg")) {
            ext = str.substring(str.indexOf(".mpg"));
            return str.substring(0, str.indexOf(".mkv"));
        } else if (str.contains(".mpv")) {
            ext = str.substring(str.indexOf(".mpv"));
            return str.substring(0, str.indexOf(".mkv"));
        } else if (str.contains(".m4v")) {
            ext = str.substring(str.indexOf(".m4v"));
            return str.substring(0, str.indexOf(".mkv"));
        } else {
            ext = str.substring(str.indexOf(".mkv"));
            return str.substring(0, str.indexOf(".mkv"));
        }
    }

    public String getMovieYear() {
        if (movieYear.length() != 0) {
            return movieYear.substring(0, 4);
        } else {
            return null;
        }
    }
    
    public String removeIllegalName(String movieName){
        movieName = movieName.replace(".", " ");
        movieName = movieName.replace(":", " ");
        movieName = movieName.replace(";", " ");
        movieName = movieName.replace("-", " ");
        movieName = movieName.replace("[", " ");
        movieName = movieName.replace("]", " ");
        movieName = movieName.replace("(", " ");
        movieName = movieName.replace(")", " ");
        movieName = movieName.replace("{", " ");
        movieName = movieName.replace("}", " ");
        movieName = movieName.replaceAll("\\s+", " ");
        movieName = movieName.trim();
        return movieName;
    }
}
