
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.*;

public class FindMovies implements Runnable {

    private String movieName;
    private UI uiClass;
    private String[] extensions = {"avi", "mkv", "mp4", "mpg", "mpv", "m4v", "mov"};

    public FindMovies(UI ui) {
        uiClass = ui;
    }

    @Override
    public void run() {
        while (true) {
            //uiClass.writeToLog("scanning for movies");
            File movieFile = getMovies();
            if (movieFile == null) {
                // System.out.println("no movie found");
            } else {
                RenameMovie r = new RenameMovie(movieFile, this, uiClass);
            }
            try {
                //uiClass.writeToLog("waiting for 5 seconds");
                Thread.sleep(5000);
            } catch (InterruptedException ex) {
                System.out.println("thread fialed to sleep");
            }
        }
    }

    private boolean scanningForMovies = false;

    public boolean isScanning() {
        return scanningForMovies;
    }

    private File getMovies() {

        if (!uiClass.sourceIsValid() || !uiClass.destinationIsValid()) {
            if (!uiClass.sourceIsValid()) {
                uiClass.writeToLog("error: source folder doesn't exist");
            } else {
                uiClass.writeToLog("error: destination folder doesn't exist");
            }
            uiClass.writeToLog("stopping the monitoring service");
            uiClass.stopMonitoringService();
        }
        File file = new File(uiClass.getSource());
        scanningForMovies = true;
        Collection<File> coll = FileUtils.listFiles(file, extensions, true);
        if (!coll.isEmpty()) {
            Iterator<File> iter = coll.iterator();
            File temp;
            while (iter.hasNext()) {
                temp = iter.next();
                if (temp.getName().contains("##unrenamable##")) {
                    continue;
                } else {
                    scanningForMovies = false;
                    uiClass.writeToLog("found a movie");
                    return temp;
                }
            }
            scanningForMovies = false;
            return null;
        } else {
            //uiClass.writeToLog("no movies found");
            scanningForMovies = false;
            return null;
        }

    }

}
