/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi.tools;

import info.movito.themoviedbapi.tools.MovieDbException;
import info.movito.themoviedbapi.tools.RequestMethod;
import info.movito.themoviedbapi.tools.UrlReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebBrowser
implements UrlReader {
    private static final Logger logger = LoggerFactory.getLogger(WebBrowser.class);
    private static Map<String, String> browserProperties = new HashMap<String, String>();
    private static Map<String, Map<String, String>> cookies = new HashMap<String, Map<String, String>>();
    private static String proxyHost = null;
    private static String proxyPort = null;
    private static String proxyUsername = null;
    private static String proxyPassword = null;
    private static String proxyEncodedPassword = null;
    private static int webTimeoutConnect = 25000;
    private static int webTimeoutRead = 90000;

    public void setProxy(String host, String port, String username, String password) {
        WebBrowser.setProxyHost(host);
        WebBrowser.setProxyPort(port);
        WebBrowser.setProxyUsername(username);
        WebBrowser.setProxyPassword(password);
    }

    public void setTimeout(int connect, int read) {
        WebBrowser.setWebTimeoutConnect(connect);
        WebBrowser.setWebTimeoutRead(read);
    }

    private static void populateBrowserProperties() {
        if (browserProperties.isEmpty()) {
            browserProperties.put("User-Agent", "Mozilla/5.25 Netscape/5.0 (Windows; I; Win95)");
            browserProperties.put("Accept", "application/json");
            browserProperties.put("Content-type", "application/json");
        }
    }

    public String request(String url) {
        try {
            return this.request(new URL(url), null, RequestMethod.GET);
        }
        catch (MalformedURLException ex) {
            throw new MovieDbException(url, ex);
        }
    }

    public static URLConnection openProxiedConnection(URL url) {
        try {
            if (proxyHost != null) {
                System.getProperties().put("proxySet", "true");
                System.getProperties().put("proxyHost", proxyHost);
                System.getProperties().put("proxyPort", proxyPort);
            }
            URLConnection cnx = url.openConnection();
            if (proxyUsername != null) {
                cnx.setRequestProperty("Proxy-Authorization", proxyEncodedPassword);
            }
            return cnx;
        }
        catch (IOException ex) {
            throw new MovieDbException(url.toString(), ex);
        }
    }

    @Override
    public String request(URL url, String jsonBody, RequestMethod requestMethod) {
        return WebBrowser.request(url, jsonBody, requestMethod.equals((Object)RequestMethod.DELETE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(URL url, String jsonBody, boolean isDeleteRequest) {
        StringWriter content = null;
        try {
            content = new StringWriter();
            BufferedReader in = null;
            HttpURLConnection cnx = null;
            try {
                String line;
                cnx = (HttpURLConnection)WebBrowser.openProxiedConnection(url);
                if (isDeleteRequest) {
                    cnx.setDoOutput(true);
                    cnx.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    cnx.setRequestMethod("DELETE");
                }
                WebBrowser.sendHeader(cnx);
                if (jsonBody != null) {
                    cnx.setDoOutput(true);
                    OutputStreamWriter wr = new OutputStreamWriter(cnx.getOutputStream());
                    wr.write(jsonBody);
                    wr.flush();
                }
                WebBrowser.readHeader(cnx);
                if (cnx.getResponseCode() >= 400) {
                    if (cnx.getErrorStream() == null) {
                        throw new MovieDbException("error stream was null");
                    }
                    in = new BufferedReader(new InputStreamReader(cnx.getErrorStream(), WebBrowser.getCharset(cnx)));
                } else {
                    in = new BufferedReader(new InputStreamReader(cnx.getInputStream(), WebBrowser.getCharset(cnx)));
                }
                while ((line = in.readLine()) != null) {
                    content.write(line);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (cnx != null) {
                    cnx.disconnect();
                }
            }
            String string = content.toString();
            return string;
        }
        catch (IOException ex) {
            throw new MovieDbException(url.toString(), ex);
        }
        finally {
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException ex) {
                    logger.debug("Failed to close connection: " + ex.getMessage());
                }
            }
        }
    }

    private static void sendHeader(URLConnection cnx) {
        WebBrowser.populateBrowserProperties();
        for (Map.Entry<String, String> browserProperty : browserProperties.entrySet()) {
            cnx.setRequestProperty(browserProperty.getKey(), browserProperty.getValue());
        }
        String cookieHeader = WebBrowser.createCookieHeader(cnx);
        if (!cookieHeader.isEmpty()) {
            cnx.setRequestProperty("Cookie", cookieHeader);
        }
    }

    private static String createCookieHeader(URLConnection cnx) {
        String host = cnx.getURL().getHost();
        StringBuilder cookiesHeader = new StringBuilder();
        for (Map.Entry<String, Map<String, String>> domainCookies : cookies.entrySet()) {
            if (!host.endsWith(domainCookies.getKey())) continue;
            for (Map.Entry<String, String> cookie : domainCookies.getValue().entrySet()) {
                cookiesHeader.append(cookie.getKey());
                cookiesHeader.append("=");
                cookiesHeader.append(cookie.getValue());
                cookiesHeader.append(";");
            }
        }
        if (cookiesHeader.length() > 0) {
            cookiesHeader.deleteCharAt(cookiesHeader.length() - 1);
        }
        return cookiesHeader.toString();
    }

    private static void readHeader(URLConnection cnx) {
        for (Map.Entry<String, List<String>> header : cnx.getHeaderFields().entrySet()) {
            if (!"Set-Cookie".equals(header.getKey())) continue;
            for (String cookieHeader : header.getValue()) {
                Map<String, String> domainCookies;
                String[] cookieElements = cookieHeader.split(" *; *");
                if (cookieElements.length < 1) continue;
                String[] firstElem = cookieElements[0].split(" *= *");
                String cookieName = firstElem[0];
                String cookieValue = firstElem.length > 1 ? firstElem[1] : null;
                String cookieDomain = null;
                for (int i = 1; i < cookieElements.length; ++i) {
                    String[] cookieElement = cookieElements[i].split(" *= *");
                    if (!"domain".equals(cookieElement[0])) continue;
                    cookieDomain = cookieElement.length > 1 ? cookieElement[1] : null;
                    break;
                }
                if (cookieDomain == null) {
                    cookieDomain = cnx.getURL().getHost();
                }
                if ((domainCookies = cookies.get(cookieDomain)) == null) {
                    domainCookies = new HashMap<String, String>();
                    cookies.put(cookieDomain, domainCookies);
                }
                domainCookies.put(cookieName, cookieValue);
            }
        }
    }

    private static Charset getCharset(URLConnection cnx) {
        Matcher m;
        Charset charset = null;
        String contentType = cnx.getContentType();
        if (contentType != null && (m = Pattern.compile("harset *=[ '\"]*([^ ;'\"]+)[ ;'\"]*").matcher(contentType)).find()) {
            String encoding = m.group(1);
            try {
                charset = Charset.forName(encoding);
            }
            catch (UnsupportedCharsetException e) {
                // empty catch block
            }
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return charset;
    }

    public static String getProxyHost() {
        return proxyHost;
    }

    public static void setProxyHost(String myProxyHost) {
        proxyHost = myProxyHost;
    }

    public static String getProxyPort() {
        return proxyPort;
    }

    public static void setProxyPort(String myProxyPort) {
        proxyPort = myProxyPort;
    }

    public static String getProxyUsername() {
        return proxyUsername;
    }

    public static void setProxyUsername(String myProxyUsername) {
        proxyUsername = myProxyUsername;
    }

    public static String getProxyPassword() {
        return proxyPassword;
    }

    public static void setProxyPassword(String myProxyPassword) {
        proxyPassword = myProxyPassword;
        if (proxyUsername != null) {
            proxyEncodedPassword = proxyUsername + ":" + proxyPassword;
            proxyEncodedPassword = "Basic " + new String(Base64.encodeBase64((byte[])(proxyUsername + ":" + proxyPassword).getBytes()));
        }
    }

    public static int getWebTimeoutConnect() {
        return webTimeoutConnect;
    }

    public static int getWebTimeoutRead() {
        return webTimeoutRead;
    }

    public static void setWebTimeoutConnect(int webTimeoutConnect) {
        WebBrowser.webTimeoutConnect = webTimeoutConnect;
    }

    public static void setWebTimeoutRead(int webTimeoutRead) {
        WebBrowser.webTimeoutRead = webTimeoutRead;
    }
}

