/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi.model.people;

import com.fasterxml.jackson.annotation.JsonProperty;
import info.movito.themoviedbapi.model.people.Person;
import info.movito.themoviedbapi.model.people.PersonType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PersonPeople
extends Person {
    private static final String CAST_DEPARTMENT = "acting";
    private static final String CAST_JOB = "actor";
    private static final String DEFAULT_STRING = "";
    private PersonType personType = PersonType.PERSON;
    private String department;
    private String job;
    private String character;
    private int order = -1;
    @JsonProperty(value="adult")
    private boolean adult = false;
    @JsonProperty(value="also_known_as")
    private List<String> aka = new ArrayList<String>();
    @JsonProperty(value="biography")
    private String biography;
    @JsonProperty(value="birthday")
    private String birthday;
    @JsonProperty(value="deathday")
    private String deathday;
    @JsonProperty(value="homepage")
    private String homepage;
    @JsonProperty(value="place_of_birth")
    private String birthplace;
    @JsonProperty(value="imdb_id")
    private String imdbId;
    @JsonProperty(value="popularity")
    private float popularity = 0.0f;

    public void addCrew(int id, String name, String profilePath, String department, String job) {
        this.setPersonType(PersonType.CREW);
        this.setId(id);
        this.setName(name);
        this.setProfilePath(profilePath);
        this.setDepartment(department);
        this.setJob(job);
        this.setCharacter(DEFAULT_STRING);
        this.setOrder(-1);
    }

    public void addCast(int id, String name, String profilePath, String character, int order) {
        this.setPersonType(PersonType.CAST);
        this.setId(id);
        this.setName(name);
        this.setProfilePath(profilePath);
        this.setCharacter(character);
        this.setOrder(order);
        this.setDepartment(CAST_DEPARTMENT);
        this.setJob(CAST_JOB);
    }

    public String getCharacter() {
        return this.character;
    }

    public String getDepartment() {
        return this.department;
    }

    public String getJob() {
        return this.job;
    }

    public int getOrder() {
        return this.order;
    }

    public PersonType getPersonType() {
        return this.personType;
    }

    public boolean isAdult() {
        return this.adult;
    }

    public List<String> getAka() {
        return this.aka;
    }

    public String getBiography() {
        return this.biography;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public String getBirthplace() {
        return this.birthplace;
    }

    public String getDeathday() {
        return this.deathday;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getImdbId() {
        return this.imdbId;
    }

    public float getPopularity() {
        return this.popularity;
    }

    public void setCharacter(String character) {
        this.character = character;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public void setJob(String job) {
        this.job = StringUtils.trimToEmpty((String)job);
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setPersonType(PersonType personType) {
        this.personType = personType;
    }

    public void setAdult(boolean adult) {
        this.adult = adult;
    }

    public void setAka(List<String> aka) {
        this.aka = aka;
    }

    public void setBiography(String biography) {
        this.biography = StringUtils.trimToEmpty((String)biography);
    }

    public void setBirthday(String birthday) {
        this.birthday = StringUtils.trimToEmpty((String)birthday);
    }

    public void setBirthplace(String birthplace) {
        this.birthplace = StringUtils.trimToEmpty((String)birthplace);
    }

    public void setDeathday(String deathday) {
        this.deathday = StringUtils.trimToEmpty((String)deathday);
    }

    public void setHomepage(String homepage) {
        this.homepage = StringUtils.trimToEmpty((String)homepage);
    }

    public void setImdbId(String imdbId) {
        this.imdbId = StringUtils.trimToEmpty((String)imdbId);
    }

    public void setPopularity(float popularity) {
        this.popularity = popularity;
    }
}

