/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import info.movito.themoviedbapi.model.Artwork;
import info.movito.themoviedbapi.model.ArtworkType;
import info.movito.themoviedbapi.model.core.IdElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MovieImages
extends IdElement {
    @JsonProperty(value="backdrops")
    private List<Artwork> backdrops;
    @JsonProperty(value="posters")
    private List<Artwork> posters;
    @JsonProperty(value="profiles")
    private List<Artwork> profiles;
    @JsonProperty(value="stills")
    private List<Artwork> stills;

    public List<Artwork> getBackdrops() {
        return this.backdrops;
    }

    public List<Artwork> getPosters() {
        return this.posters;
    }

    public List<Artwork> getProfiles() {
        return this.profiles;
    }

    public List<Artwork> getStills() {
        return this.stills;
    }

    public void setBackdrops(List<Artwork> backdrops) {
        this.backdrops = backdrops;
    }

    public void setPosters(List<Artwork> posters) {
        this.posters = posters;
    }

    public void setProfiles(List<Artwork> profiles) {
        this.profiles = profiles;
    }

    public void setStills(List<Artwork> stills) {
        this.stills = stills;
    }

    public List<Artwork> getAll(ArtworkType ... artworkList) {
        ArrayList<Artwork> artwork = new ArrayList<Artwork>();
        ArrayList<ArtworkType> types = artworkList.length > 0 ? new ArrayList<ArtworkType>(Arrays.asList(artworkList)) : new ArrayList<ArtworkType>(Arrays.asList(ArtworkType.values()));
        if (types.contains((Object)ArtworkType.POSTER)) {
            this.updateArtworkType(this.posters, ArtworkType.POSTER);
            artwork.addAll(this.posters);
        }
        if (types.contains((Object)ArtworkType.BACKDROP)) {
            this.updateArtworkType(this.backdrops, ArtworkType.BACKDROP);
            artwork.addAll(this.backdrops);
        }
        if (types.contains((Object)ArtworkType.PROFILE)) {
            this.updateArtworkType(this.profiles, ArtworkType.PROFILE);
            artwork.addAll(this.profiles);
        }
        return artwork;
    }

    private void updateArtworkType(List<Artwork> artworkList, ArtworkType type) {
        for (Artwork artwork : artworkList) {
            artwork.setArtworkType(type);
        }
    }
}

