/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.Utils;
import info.movito.themoviedbapi.model.Credits;
import info.movito.themoviedbapi.model.tv.TvEpisode;
import info.movito.themoviedbapi.tools.ApiUrl;

public class TmdbTvEpisodes
extends AbstractTmdbApi {
    public static final String TMDB_METHOD_TV_EPISODE = "episode";

    TmdbTvEpisodes(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public TvEpisode getEpisode(int seriesId, int seasonNumber, int episodeNumber, String language, EpisodeMethod ... appendToResponse) {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, "season", seasonNumber, TMDB_METHOD_TV_EPISODE, episodeNumber);
        apiUrl.addLanguage(language);
        apiUrl.appendToResponse(Utils.asStringArray((Object[])appendToResponse));
        return this.mapJsonResult(apiUrl, TvEpisode.class);
    }

    public Credits getCredits(int seriesId, int seasonNumber, int episodeNumber, String language) {
        ApiUrl apiUrl = new ApiUrl(new Object[]{"tv", seriesId, "season", seasonNumber, TMDB_METHOD_TV_EPISODE, episodeNumber, EpisodeMethod.credits});
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, Credits.class);
    }

    public static enum EpisodeMethod {
        credits,
        external_ids,
        images,
        videos;

    }
}

