/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.TvResultsPage;
import info.movito.themoviedbapi.Utils;
import info.movito.themoviedbapi.model.Credits;
import info.movito.themoviedbapi.model.config.Timezone;
import info.movito.themoviedbapi.model.tv.TvSeries;
import info.movito.themoviedbapi.tools.ApiUrl;

public class TmdbTV
extends AbstractTmdbApi {
    public static final String TMDB_METHOD_TV = "tv";
    public static final String TMDB_METHOD_POPULAR = "popular";
    public static final String TMDB_METHOD_CREDITS = "credits";
    public static final String TMDB_METHOD_ONTHEAIR = "on_the_air";
    public static final String TMDB_METHOD_AIRINGTODAY = "airing_today";
    public static final String TMDB_METHOD_TOPRATED = "top_rated";

    TmdbTV(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public TvSeries getSeries(int seriesId, String language, TvMethod ... appendToResponse) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId);
        apiUrl.addLanguage(language);
        apiUrl.appendToResponse(Utils.asStringArray((Object[])appendToResponse));
        return this.mapJsonResult(apiUrl, TvSeries.class);
    }

    public Credits getCredits(int seriesId, String language) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, TMDB_METHOD_CREDITS);
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, Credits.class);
    }

    public TvResultsPage getPopular(String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, TMDB_METHOD_POPULAR);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TvResultsPage.class);
    }

    public TvResultsPage getAiringToday(String language, Integer page, Timezone timezone) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, TMDB_METHOD_AIRINGTODAY);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        if (timezone != null) {
            apiUrl.addParam("timezone", timezone);
        }
        return this.mapJsonResult(apiUrl, TvResultsPage.class);
    }

    public TvResultsPage getOnTheAir(String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, TMDB_METHOD_ONTHEAIR);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TvResultsPage.class);
    }

    public TvResultsPage getTopRated(String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, TMDB_METHOD_TOPRATED);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TvResultsPage.class);
    }

    public static enum TvMethod {
        credits,
        external_ids,
        images,
        videos;

    }
}

