/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.Artwork;
import info.movito.themoviedbapi.model.ArtworkType;
import info.movito.themoviedbapi.model.MovieImages;
import info.movito.themoviedbapi.model.core.ResultsPage;
import info.movito.themoviedbapi.model.people.Person;
import info.movito.themoviedbapi.model.people.PersonCredits;
import info.movito.themoviedbapi.model.people.PersonPeople;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.MovieDbException;
import java.util.List;

public class TmdbPeople
extends AbstractTmdbApi {
    public static final String TMDB_METHOD_PERSON = "person";

    TmdbPeople(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public PersonPeople getPersonInfo(int personId, String ... appendToResponse) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, personId);
        apiUrl.appendToResponse(appendToResponse);
        return this.mapJsonResult(apiUrl, PersonPeople.class);
    }

    public PersonCredits getPersonCredits(int personId) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, personId, "credits");
        return this.mapJsonResult(apiUrl, PersonCredits.class);
    }

    public List<Artwork> getPersonImages(int personId) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, personId, "images");
        return this.mapJsonResult(apiUrl, MovieImages.class).getAll(ArtworkType.PROFILE);
    }

    public void getPersonChanges(int personId, String startDate, String endDate) {
        throw new MovieDbException("Not implemented yet");
    }

    public PersonResultsPage getPersonPopular(Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, "popular");
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, PersonResultsPage.class);
    }

    public PersonPeople getPersonLatest() {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, "latest");
        return this.mapJsonResult(apiUrl, PersonPeople.class);
    }

    public static class PersonResultsPage
    extends ResultsPage<Person> {
    }
}

