/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import com.fasterxml.jackson.annotation.JsonProperty;
import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbAccount;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.Utils;
import info.movito.themoviedbapi.model.AlternativeTitle;
import info.movito.themoviedbapi.model.Credits;
import info.movito.themoviedbapi.model.MovieDb;
import info.movito.themoviedbapi.model.MovieImages;
import info.movito.themoviedbapi.model.MovieTranslations;
import info.movito.themoviedbapi.model.MoviesAlternativeTitles;
import info.movito.themoviedbapi.model.ReleaseInfo;
import info.movito.themoviedbapi.model.Translation;
import info.movito.themoviedbapi.model.Video;
import info.movito.themoviedbapi.model.changes.ChangesItems;
import info.movito.themoviedbapi.model.core.IdElement;
import info.movito.themoviedbapi.model.core.MovieResultsPage;
import info.movito.themoviedbapi.model.core.SessionToken;
import info.movito.themoviedbapi.model.keywords.Keyword;
import info.movito.themoviedbapi.tools.ApiUrl;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TmdbMovies
extends AbstractTmdbApi {
    public static final String TMDB_METHOD_MOVIE = "movie";
    private static final String PARAM_START_DATE = "start_date";
    private static final String PARAM_END_DATE = "end_date";
    private static final String PARAM_COUNTRY = "country";

    public TmdbMovies(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public MovieDb getMovie(int movieId, String language, MovieMethod ... appendToResponse) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId);
        apiUrl.addLanguage(language);
        apiUrl.appendToResponse(Utils.asStringArray((Object[])appendToResponse));
        return this.mapJsonResult(apiUrl, MovieDb.class);
    }

    public List<AlternativeTitle> getAlternativeTitles(int movieId, String country) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "alternative_titles");
        if (StringUtils.isNotBlank((CharSequence)country)) {
            apiUrl.addParam(PARAM_COUNTRY, country);
        }
        return this.mapJsonResult(apiUrl, MoviesAlternativeTitles.class).getTitles();
    }

    public Credits getCredits(int movieId) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "credits");
        return this.mapJsonResult(apiUrl, Credits.class);
    }

    public MovieImages getImages(int movieId, String language) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "images");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, MovieImages.class);
    }

    public List<Keyword> getKeywords(int movieId) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "keywords");
        return this.mapJsonResult((ApiUrl)apiUrl, KeywordResults.class).results;
    }

    public List<ReleaseInfo> getReleaseInfo(int movieId, String language) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "releases");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, ReleaseInfoResults.class).countries;
    }

    public List<Video> getVideos(int movieId, String language) {
        ApiUrl apiUrl = new ApiUrl(new Object[]{TMDB_METHOD_MOVIE, movieId, MovieMethod.videos});
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, Video.Results.class).getVideos();
    }

    public List<Translation> getTranslations(int movieId) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "translations");
        return this.mapJsonResult(apiUrl, MovieTranslations.class).getTranslations();
    }

    public MovieResultsPage getSimilarMovies(int movieId, String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "similar");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public TmdbAccount.MovieListResultsPage getListsContaining(int movieId, SessionToken sessionToken, String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "lists");
        apiUrl.addParam("session_id", sessionToken);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TmdbAccount.MovieListResultsPage.class);
    }

    public ChangesItems getChanges(int movieId, String startDate, String endDate) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "changes");
        if (StringUtils.isNotBlank((CharSequence)startDate)) {
            apiUrl.addParam(PARAM_START_DATE, startDate);
        }
        if (StringUtils.isNotBlank((CharSequence)endDate)) {
            apiUrl.addParam(PARAM_END_DATE, endDate);
        }
        return this.mapJsonResult(apiUrl, ChangesItems.class);
    }

    public MovieDb getLatestMovie() {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, "latest");
        return this.mapJsonResult(apiUrl, MovieDb.class);
    }

    public MovieResultsPage getUpcoming(String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, "upcoming");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public MovieResultsPage getNowPlayingMovies(String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, "now-playing");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public MovieResultsPage getPopularMovieList(String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, "popular");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public MovieResultsPage getTopRatedMovies(String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, "top-rated");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public static class ReleaseInfoResults
    extends IdElement {
        @JsonProperty(value="countries")
        private List<ReleaseInfo> countries;

        public List<ReleaseInfo> getCountries() {
            return this.countries;
        }
    }

    private static class KeywordResults
    extends IdElement {
        @JsonProperty(value="keywords")
        List<Keyword> results;

        private KeywordResults() {
        }
    }

    public static enum MovieMethod {
        alternative_titles,
        credits,
        images,
        keywords,
        releases,
        trailers,
        videos,
        translations,
        similar_movies,
        reviews,
        lists,
        changes,
        latest,
        upcoming,
        now_playing,
        popular,
        top_rated;

    }
}

