/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import com.fasterxml.jackson.annotation.JsonProperty;
import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.Genre;
import info.movito.themoviedbapi.model.core.AbstractJsonMapping;
import info.movito.themoviedbapi.model.core.MovieResultsPage;
import info.movito.themoviedbapi.tools.ApiUrl;
import java.util.List;

public class TmdbGenre
extends AbstractTmdbApi {
    public static final String PARAM_INCLUDE_ALL_MOVIES = "include_all_movies";
    public static final String TMDB_METHOD_GENRE = "genre";

    TmdbGenre(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public List<Genre> getGenreList(String language) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_GENRE, "list");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, Genres.class).genres;
    }

    public MovieResultsPage getGenreMovies(int genreId, String language, Integer page, boolean includeAllMovies) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_GENRE, genreId, "movies");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addParam(PARAM_INCLUDE_ALL_MOVIES, includeAllMovies);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    private static class Genres
    extends AbstractJsonMapping {
        @JsonProperty(value="genres")
        private List<Genre> genres;

        private Genres() {
        }
    }
}

