/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.TmdbAccount;
import info.movito.themoviedbapi.TmdbAuthentication;
import info.movito.themoviedbapi.TmdbChanges;
import info.movito.themoviedbapi.TmdbCollections;
import info.movito.themoviedbapi.TmdbCompany;
import info.movito.themoviedbapi.TmdbConfig;
import info.movito.themoviedbapi.TmdbDiscover;
import info.movito.themoviedbapi.TmdbFind;
import info.movito.themoviedbapi.TmdbGenre;
import info.movito.themoviedbapi.TmdbJobs;
import info.movito.themoviedbapi.TmdbKeywords;
import info.movito.themoviedbapi.TmdbLists;
import info.movito.themoviedbapi.TmdbMovies;
import info.movito.themoviedbapi.TmdbPeople;
import info.movito.themoviedbapi.TmdbReviews;
import info.movito.themoviedbapi.TmdbSearch;
import info.movito.themoviedbapi.TmdbTV;
import info.movito.themoviedbapi.TmdbTimezones;
import info.movito.themoviedbapi.TmdbTvEpisodes;
import info.movito.themoviedbapi.TmdbTvSeasons;
import info.movito.themoviedbapi.model.JobDepartment;
import info.movito.themoviedbapi.model.config.Timezone;
import info.movito.themoviedbapi.model.config.TmdbConfiguration;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.MovieDbException;
import info.movito.themoviedbapi.tools.RequestMethod;
import info.movito.themoviedbapi.tools.UrlReader;
import info.movito.themoviedbapi.tools.WebBrowser;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TmdbApi {
    private String apiKey;
    private TmdbConfiguration tmdbConfig;
    private UrlReader urlReader;

    public TmdbApi(String apiKey) {
        this(apiKey, new WebBrowser());
    }

    public TmdbApi(String apiKey, UrlReader urlReader) {
        this.urlReader = urlReader;
        this.apiKey = apiKey;
        try {
            this.tmdbConfig = new TmdbConfig(this).getConfig().getTmdbConfiguration();
        }
        catch (MovieDbException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new MovieDbException("Failed to read configuration", ex);
        }
    }

    public String requestWebPage(ApiUrl apiUrl, String jsonBody, RequestMethod requestMethod) {
        assert (StringUtils.isNotBlank((CharSequence)this.apiKey));
        apiUrl.addParam("api_key", this.getApiKey());
        return this.urlReader.request(apiUrl.buildUrl(), jsonBody, requestMethod);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public TmdbConfiguration getConfiguration() {
        return this.tmdbConfig;
    }

    public List<Timezone> getTimezones() {
        return new TmdbTimezones(this).getTimezones();
    }

    public TmdbAccount getAccount() {
        return new TmdbAccount(this);
    }

    public TmdbLists getLists() {
        return new TmdbLists(this);
    }

    public TmdbMovies getMovies() {
        return new TmdbMovies(this);
    }

    public TmdbSearch getSearch() {
        return new TmdbSearch(this);
    }

    public TmdbGenre getGenre() {
        return new TmdbGenre(this);
    }

    public TmdbCompany getCompany() {
        return new TmdbCompany(this);
    }

    public TmdbCollections getCollections() {
        return new TmdbCollections(this);
    }

    public TmdbPeople getPeople() {
        return new TmdbPeople(this);
    }

    public TmdbAuthentication getAuthentication() {
        return new TmdbAuthentication(this);
    }

    public TmdbChanges getChanges() {
        return new TmdbChanges(this);
    }

    public TmdbDiscover getDiscover() {
        return new TmdbDiscover(this);
    }

    public List<JobDepartment> getJobs() {
        return new TmdbJobs(this).getJobs();
    }

    public TmdbKeywords getKeywords() {
        return new TmdbKeywords(this);
    }

    public TmdbReviews getReviews() {
        return new TmdbReviews(this);
    }

    public TmdbTV getTvSeries() {
        return new TmdbTV(this);
    }

    public TmdbTvSeasons getTvSeasons() {
        return new TmdbTvSeasons(this);
    }

    public TmdbTvEpisodes getTvEpisodes() {
        return new TmdbTvEpisodes(this);
    }

    public TmdbFind getFind() {
        return new TmdbFind(this);
    }
}

