/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.TvResultsPage;
import info.movito.themoviedbapi.Utils;
import info.movito.themoviedbapi.model.MovieList;
import info.movito.themoviedbapi.model.config.Account;
import info.movito.themoviedbapi.model.core.AccountID;
import info.movito.themoviedbapi.model.core.MovieResultsPage;
import info.movito.themoviedbapi.model.core.ResponseStatus;
import info.movito.themoviedbapi.model.core.ResultsPage;
import info.movito.themoviedbapi.model.core.SessionToken;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.MovieDbException;
import java.util.Collections;
import java.util.HashMap;

public class TmdbAccount
extends AbstractTmdbApi {
    public static final String PARAM_SESSION = "session_id";
    public static final String TMDB_METHOD_ACCOUNT = "account";

    TmdbAccount(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public Account getAccount(SessionToken sessionToken) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT);
        apiUrl.addParam(PARAM_SESSION, sessionToken);
        return this.mapJsonResult(apiUrl, Account.class);
    }

    public MovieListResultsPage getLists(SessionToken sessionToken, AccountID accountId, String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "lists");
        apiUrl.addParam(PARAM_SESSION, sessionToken);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieListResultsPage.class);
    }

    public MovieResultsPage getRatedMovies(SessionToken sessionToken, AccountID accountId, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "rated_movies");
        apiUrl.addParam(PARAM_SESSION, sessionToken);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public boolean postMovieRating(SessionToken sessionToken, Integer movieId, Integer rating) {
        ApiUrl apiUrl = new ApiUrl("movie", movieId, "rating");
        apiUrl.addParam(PARAM_SESSION, sessionToken);
        if (rating < 0 || rating > 10) {
            throw new MovieDbException("rating out of range");
        }
        String jsonBody = Utils.convertToJson(jsonMapper, Collections.singletonMap("value", rating));
        return this.mapJsonResult(apiUrl, ResponseStatus.class, jsonBody).getStatusCode() == 12;
    }

    public MovieResultsPage getFavoriteMovies(SessionToken sessionToken, AccountID accountId) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "favorite/movies");
        apiUrl.addParam(PARAM_SESSION, sessionToken);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public TvResultsPage getFavoriteSeries(SessionToken sessionToken, AccountID accountId, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "favorite/tv");
        apiUrl.addParam(PARAM_SESSION, sessionToken);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TvResultsPage.class);
    }

    public ResponseStatus addFavorite(SessionToken sessionToken, AccountID accountId, Integer movieId, MediaType mediaType) {
        return this.changeFavoriteStatus(sessionToken, accountId, movieId, mediaType, true);
    }

    public ResponseStatus removeFavorite(SessionToken sessionToken, AccountID accountId, Integer movieId, MediaType mediaType) {
        return this.changeFavoriteStatus(sessionToken, accountId, movieId, mediaType, false);
    }

    private ResponseStatus changeFavoriteStatus(SessionToken sessionToken, AccountID accountId, Integer movieId, MediaType mediaType, boolean isFavorite) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "favorite");
        apiUrl.addParam(PARAM_SESSION, sessionToken);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("media_type", mediaType.toString());
        body.put("media_id", movieId);
        body.put("favorite", isFavorite);
        String jsonBody = Utils.convertToJson(jsonMapper, body);
        return this.mapJsonResult(apiUrl, ResponseStatus.class, jsonBody);
    }

    public MovieResultsPage getWatchListMovies(SessionToken sessionToken, AccountID accountId, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "watchlist/movies");
        apiUrl.addParam(PARAM_SESSION, sessionToken);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public TvResultsPage getWatchListSeries(SessionToken sessionToken, AccountID accountId, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "watchlist/tv");
        apiUrl.addParam(PARAM_SESSION, sessionToken);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TvResultsPage.class);
    }

    public ResponseStatus addToWatchList(SessionToken sessionToken, AccountID accountId, Integer movieId, MediaType mediaType) {
        return this.modifyWatchList(sessionToken, accountId, movieId, mediaType, true);
    }

    public ResponseStatus removeFromWatchList(SessionToken sessionToken, AccountID accountId, Integer movieId, MediaType mediaType) {
        return this.modifyWatchList(sessionToken, accountId, movieId, mediaType, false);
    }

    private ResponseStatus modifyWatchList(SessionToken sessionToken, AccountID accountId, Integer movieId, MediaType mediaType, boolean isWatched) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "watchlist");
        apiUrl.addParam(PARAM_SESSION, sessionToken);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("media_type", mediaType.toString());
        body.put("media_id", movieId);
        body.put("watchlist", isWatched);
        String jsonBody = Utils.convertToJson(jsonMapper, body);
        return this.mapJsonResult(apiUrl, ResponseStatus.class, jsonBody);
    }

    public static enum MediaType {
        MOVIE,
        TV;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static class MovieListResultsPage
    extends ResultsPage<MovieList> {
    }
}

