/*
 * Decompiled with CFR 0.152.
 */
package org.yamj.api.common.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.yamj.api.common.http.AbstractPoolingHttpClient;
import org.yamj.api.common.http.UserAgentSelector;

public class DefaultPoolingHttpClient
extends AbstractPoolingHttpClient {
    private static final String INVALID_URL = "Invalid URL ";
    protected boolean randomUserAgent = false;

    public DefaultPoolingHttpClient() {
        this(null, null);
    }

    public DefaultPoolingHttpClient(ClientConnectionManager conman) {
        this(conman, null);
    }

    public DefaultPoolingHttpClient(HttpParams params) {
        this(null, params);
    }

    public DefaultPoolingHttpClient(ClientConnectionManager connectionManager, HttpParams httpParams) {
        super(connectionManager, httpParams);
    }

    public final void setRandomUserAgent(boolean randomUserAgent) {
        this.randomUserAgent = randomUserAgent;
    }

    public String requestContent(URL url) throws IOException {
        return this.requestContent(url, null);
    }

    public String requestContent(URL url, Charset charset) throws IOException {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(INVALID_URL + url, ex);
        }
        return this.requestContent(uri, charset);
    }

    public String requestContent(String uri) throws IOException {
        return this.requestContent(uri, null);
    }

    public String requestContent(String uri, Charset charset) throws IOException {
        HttpGet httpGet = new HttpGet(uri);
        return this.requestContent(httpGet, charset);
    }

    public String requestContent(URI uri) throws IOException {
        return this.requestContent(uri, null);
    }

    public String requestContent(URI uri, Charset charset) throws IOException {
        HttpGet httpGet = new HttpGet(uri);
        return this.requestContent(httpGet, charset);
    }

    public String requestContent(HttpGet httpGet) throws IOException {
        return this.requestContent(httpGet, null);
    }

    public String requestContent(HttpGet httpGet, Charset charset) throws IOException {
        if (this.randomUserAgent) {
            httpGet.setHeader("User-Agent", UserAgentSelector.randomUserAgent());
        }
        try {
            CloseableHttpResponse response = this.execute((HttpUriRequest)httpGet);
            if (response.getEntity() == null) {
                httpGet.releaseConnection();
                throw new IOException("No response for URI " + httpGet.getURI());
            }
            return this.readContent((HttpResponse)response, charset);
        }
        catch (IOException ioe) {
            httpGet.releaseConnection();
            throw ioe;
        }
    }

    public HttpEntity requestResource(URL url) throws IOException {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(INVALID_URL + url, ex);
        }
        return this.requestResource(uri);
    }

    public HttpEntity requestResource(String uri) throws IOException {
        HttpGet httpGet = new HttpGet(uri);
        return this.requestResource(httpGet);
    }

    public HttpEntity requestResource(URI uri) throws IOException {
        HttpGet httpGet = new HttpGet(uri);
        return this.requestResource(httpGet);
    }

    public HttpEntity requestResource(HttpGet httpGet) throws IOException {
        if (this.randomUserAgent) {
            httpGet.setHeader("User-Agent", UserAgentSelector.randomUserAgent());
        }
        CloseableHttpResponse response = this.execute((HttpUriRequest)httpGet);
        return response.getEntity();
    }
}

