#include<File.au3>
#include <Date.au3>
#include <FileConstants.au3>
#include<MsgBoxConstants.au3>

Global $r5, $r

_ArrivedFiles()

Func _ArrivedFiles()

	Local $PathToIGS = @DesktopDir & "\IGS_Files\"

	Do
		If FileExists($PathToIGS) Then
			Local $IGSFiles = _FileListToArrayRec($PathToIGS, "*.igs", 1, 0, 0, 2)
			If IsArray($IGSFiles) Then
				_RhStartInterface()
				If Not @error = 1 Then
					For $i = 1 To $IGSFiles[0]
						Local $FileTime = FileGetTime($IGSFiles[$i])
						Local $iFileTimeTicks = _TimeToTicks($FileTime[3], $FileTime[4], $FileTime[5])
						Local $SystemTimeTicks = _TimeToTicks(@HOUR, @MIN, @SEC)
						If $SystemTimeTicks > $iFileTimeTicks Then
							Local $iFileTimeTRef = $SystemTimeTicks - $iFileTimeTicks
							If $iFileTimeTRef <= 1200000 Then
								MsgBox($MB_SYSTEMMODAL, "", "New files arrived ---> " & StringTrimLeft($IGSFiles[$i], StringLen($PathToIGS)), 3)
								$r.Command("-_Import " & $IGSFiles[$i], False)
								If Not $r.LastCommandResult() = 0 Then
									_FileWriteLog($PathToIGS & "Report.txt", "Error Import on: " & StringTrimLeft($IGSFiles[$i], StringLen($PathToIGS)), -1)
								EndIf
;~ 								$r.Command("-_RunPythonScript (Samples.MyScript.py)")
;~ 								If Not $r.LastCommandResult() = 0 Then
;~ 									_FileWriteLog($PathToIGS & "Report.txt", "Error Import on: " & StringTrimLeft($IGSFiles[$i], StringLen($PathToIGS)), -1)
;~ 								EndIf
							EndIf
						EndIf
					Next
					_RhTerminateObject()
				EndIf
			EndIf
			Sleep(1200000)
		Else
			MsgBox($MB_SYSTEMMODAL, "", "Directory not exist, script exit !!!", 3)
			Exit 0
		EndIf
	Until @HOUR >= 16

EndFunc   ;==>_ArrivedFiles

Func _RhStartInterface()

	If ProcessExists("Rhino.exe") Then
		$r5 = ObjCreate("Rhino5x64.Interface")
		Sleep(1000)
		If IsObj($r5) Then
			$r = $r5.GetScriptObject()
		Else
			MsgBox($MB_SYSTEMMODAL, "", "Error: Rhino object not created !!!", 3)
			Return SetError(1, 0, 0)
		EndIf
	Else
		MsgBox($MB_SYSTEMMODAL, "", "Rhino is not running !!!", 3)
		Return SetError(1, 0, 0)
	EndIf

EndFunc   ;==>_RhStartInterface

Func _RhTerminateObject()

	$r = ""
	$r5 = ""

EndFunc   ;==>_RhTerminateObject


Func _RhStartNew()

	$r5 = ObjCreate("Rhino5x64.Application")
	Sleep(5000)
	If Not IsObj($r5) Then
		Exit
	Else
		If IsObj($r5) Then
			$r = $r5.GetScriptObject()
		Else
			Exit
		EndIf
	EndIf

EndFunc   ;==>_RhStartNew





